<?php
/**
 * @author Lukas Reschke <lukas@statuscode.ch>
 * @author Morris Jobke <hey@morrisjobke.de>
 *
 * @copyright Copyright (c) 2018, ownCloud GmbH
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */

namespace OCP\AppFramework\Http;

use OCP\Template;

/**
 * A generic 404 response showing an 404 error page as well to the end-user
 * @since 8.1.0
 */
class NotFoundResponse extends Response {
	/**
	 * @since 8.1.0
	 */
	public function __construct() {
		$this->setStatus(404);
	}

	/**
	 * @return string
	 * @since 8.1.0
	 */
	public function render() {
		$template = new Template('core', '404', 'guest');
		return $template->fetchPage();
	}
}
