<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* VulnerabilityState File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;
/**
* VulnerabilityState class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class VulnerabilityState extends Entity
{
    /**
    * Gets the cve
    * Common Vulnerabilities and Exposures (CVE) for the vulnerability.
    *
    * @return string|null The cve
    */
    public function getCve()
    {
        if (array_key_exists("cve", $this->_propDict)) {
            return $this->_propDict["cve"];
        } else {
            return null;
        }
    }

    /**
    * Sets the cve
    * Common Vulnerabilities and Exposures (CVE) for the vulnerability.
    *
    * @param string $val The value of the cve
    *
    * @return VulnerabilityState
    */
    public function setCve($val)
    {
        $this->_propDict["cve"] = $val;
        return $this;
    }
    /**
    * Gets the severity
    * Base Common Vulnerability Scoring System (CVSS) severity score for this vulnerability.
    *
    * @return string|null The severity
    */
    public function getSeverity()
    {
        if (array_key_exists("severity", $this->_propDict)) {
            return $this->_propDict["severity"];
        } else {
            return null;
        }
    }

    /**
    * Sets the severity
    * Base Common Vulnerability Scoring System (CVSS) severity score for this vulnerability.
    *
    * @param string $val The value of the severity
    *
    * @return VulnerabilityState
    */
    public function setSeverity($val)
    {
        $this->_propDict["severity"] = $val;
        return $this;
    }
    /**
    * Gets the wasRunning
    * Indicates whether the detected vulnerability (file) was running at the time of detection or was the file detected at rest on the disk.
    *
    * @return bool|null The wasRunning
    */
    public function getWasRunning()
    {
        if (array_key_exists("wasRunning", $this->_propDict)) {
            return $this->_propDict["wasRunning"];
        } else {
            return null;
        }
    }

    /**
    * Sets the wasRunning
    * Indicates whether the detected vulnerability (file) was running at the time of detection or was the file detected at rest on the disk.
    *
    * @param bool $val The value of the wasRunning
    *
    * @return VulnerabilityState
    */
    public function setWasRunning($val)
    {
        $this->_propDict["wasRunning"] = $val;
        return $this;
    }
}
